/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util.timer;

import java.util.ArrayList;
import java.util.List;
import meldexun.renderlib.config.RenderLibConfig;
import meldexun.renderlib.util.GLUtil;
import meldexun.renderlib.util.timer.CPUTimer;
import meldexun.renderlib.util.timer.DummyTimer;
import meldexun.renderlib.util.timer.GLTimer;
import meldexun.renderlib.util.timer.ITimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="renderlib", value={Side.CLIENT})
public class TimerEventHandler {
    private static final ITimer gpuRenderTimer = TimerEventHandler.tryCreateGLTimer("GPU", 100);
    private static final ITimer cpuRenderTimer = new CPUTimer("CPU (Render)", 100);
    private static final ITimer cpuTickTimer = new CPUTimer("CPU (Tick)", 100);
    public static final List<ITimer> timers = new ArrayList<ITimer>();

    public static ITimer tryCreateGLTimer(String name, int maxResultCount) {
        if (!GLUtil.CAPS.OpenGL33 && !GLUtil.CAPS.GL_ARB_timer_query) {
            return new DummyTimer(name, "?");
        }
        return new GLTimer(name, maxResultCount);
    }

    @SubscribeEvent
    public static void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!RenderLibConfig.showFrameTimes) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaled = new ScaledResolution(mc);
        int x = scaled.func_78326_a() - 2;
        int y = 2;
        TimerEventHandler.drawLeftAligned(mc.field_71466_p, "avg", x - 40, y);
        TimerEventHandler.drawLeftAligned(mc.field_71466_p, "max", x, y);
        for (int i = 0; i < timers.size(); ++i) {
            TimerEventHandler.drawDebug(mc.field_71466_p, timers.get(i), x, y + (i + 1) * 10);
        }
    }

    private static void drawDebug(FontRenderer font, ITimer timer, int x, int y) {
        if (timer == null) {
            return;
        }
        int nameWidth = font.func_78256_a(timer.getName());
        int avgWidth = font.func_78256_a(timer.avgString());
        int maxWidth = font.func_78256_a(timer.maxString());
        int avgOffset = Math.max(maxWidth + 4, 40);
        int nameOffset = Math.max(avgOffset + avgWidth + 4, 80);
        TimerEventHandler.draw(font, timer.getName(), x - nameWidth - nameOffset, y);
        TimerEventHandler.draw(font, timer.avgString(), x - avgWidth - avgOffset, y);
        TimerEventHandler.draw(font, timer.maxString(), x - maxWidth, y);
    }

    private static void drawLeftAligned(FontRenderer font, String string, int x, int y) {
        TimerEventHandler.draw(font, string, x - font.func_78256_a(string), y);
    }

    private static void draw(FontRenderer font, String string, int x, int y) {
        font.func_175063_a(string, (float)x, (float)y, -1);
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            cpuRenderTimer.update();
            cpuRenderTimer.start();
            gpuRenderTimer.update();
            gpuRenderTimer.start();
        } else {
            gpuRenderTimer.stop();
            cpuRenderTimer.stop();
        }
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            cpuTickTimer.update();
            cpuTickTimer.start();
        } else {
            cpuTickTimer.stop();
        }
    }

    static {
        timers.add(gpuRenderTimer);
        timers.add(cpuRenderTimer);
        timers.add(cpuTickTimer);
    }
}

